import { createServer } from "http";
import next from "next";

const dev = process.env.NODE_ENV !== "production";
const app = next({ dev });
const handle = app.getRequestHandler();

app.prepare().then(() => {
    createServer((req, res) => {
        handle(req, res); // Let Next.js handle all requests
    }).listen(3000, (err) => {
        if (err) throw err;
        console.log("Next.js server running on http://localhost:3000");
    });
});
