"use client";

import React, { useEffect, useState } from "react";
import { API_ENDPOINTS } from "@/lib/apiEndpoints";
import { motion } from "framer-motion";

function stripHtml(html: string): string {
    if (!html) return "";
    return html.replace(/<[^>]*>?/gm, "").trim();
}

export default function AboutSection({ data }: { data: any }) {
    return (
        <section className="About-inner py-5">
            <div className="container">
                <div className="row align-items-center">
                    {/* Left Image */}
                    <div className="col-lg-6">
                        <motion.div
                            initial={{ opacity: 0, x: -60 }}
                            whileInView={{ opacity: 1, x: 0 }}
                            transition={{ duration: 0.6 }}
                        >
                            <img src={data.section_image} className="img-fluid rounded" width="500" height="350" loading="lazy" />
                        </motion.div>
                    </div>

                    {/* Right Text */}
                    <div className="col-lg-6">
                        <motion.div
                            initial={{ opacity: 0, x: 60 }}
                            whileInView={{ opacity: 1, x: 0 }}
                            transition={{ duration: 0.6 }}
                        >
                            <h3 className="fw-bold">{data.section_headline}</h3>

                            <p className="mt-3" dangerouslySetInnerHTML={{ __html: data.description }} />
                        </motion.div>
                    </div>
                </div>
            </div>
        </section>
    );
}
