"use client";

import { useEffect } from "react";
import "bootstrap/dist/css/bootstrap.min.css";
import { motion } from "framer-motion";

interface VisionSubSection {
    title: string;
    desc: string;
}

interface VisionData {
    parent: {
        headline: string;
        image: string;
    };
    subsections: VisionSubSection[];
}

interface VisionSectionProps {
    data: VisionData | null;
}

export default function VisionSection({ data }: VisionSectionProps) {
    useEffect(() => {
        import("bootstrap/dist/js/bootstrap.bundle.min.js");
    }, []);

    if (!data || !data.parent || !data.subsections?.length) {
        return null;
    }

    const { parent, subsections } = data;

    return (
        <section className="vision py-5">
            <div className="container">
                <div className="row align-items-center">
                    {/* Left Image */}
                    <div className="col-lg-6">
                        <motion.div
                            initial={{ opacity: 0, x: -50 }}
                            whileInView={{ opacity: 1, x: 0 }}
                            viewport={{ once: true }}
                        >
                            <img
                                src={parent.image}
                                className="img-fluid rounded shadow-none"
                                width={500}
                                height={350}
                                loading="lazy"
                                alt={parent.headline}
                            />
                        </motion.div>
                    </div>

                    {/* Right Accordion */}
                    <div className="col-lg-6">
                        <motion.div
                            initial={{ opacity: 0, x: 50 }}
                            whileInView={{ opacity: 1, x: 0 }}
                            viewport={{ once: true }}
                        >
                            <h3>{parent.headline}</h3>

                            <div className="accordion mt-4" id="faqAccordion">
                                {subsections.map((item, index) => {
                                    const idx = index + 1;
                                    const isFirst = idx === 1;

                                    return (
                                        <div className="accordion-item" key={idx}>
                                            <h2
                                                className="accordion-header"
                                                id={`heading-${idx}`}
                                            >
                                                <button
                                                    className={`accordion-button faq-toggle ${!isFirst ? "collapsed" : ""
                                                        }`}
                                                    type="button"
                                                    data-bs-toggle="collapse"
                                                    data-bs-target={`#faq-${idx}`}
                                                    aria-expanded={isFirst}
                                                    aria-controls={`faq-${idx}`}
                                                >
                                                    <i className="fa fa-plus me-2"></i>
                                                    <i className="fa fa-minus me-2"></i>
                                                    {item.title}
                                                </button>
                                            </h2>

                                            <div
                                                id={`faq-${idx}`}
                                                className={`accordion-collapse collapse ${isFirst ? "show" : ""
                                                    }`}
                                                aria-labelledby={`heading-${idx}`}
                                                data-bs-parent="#faqAccordion"
                                            >
                                                <div
                                                    className="accordion-body"
                                                    dangerouslySetInnerHTML={{
                                                        __html: item.desc,
                                                    }}
                                                />
                                            </div>
                                        </div>
                                    );
                                })}
                            </div>
                        </motion.div>
                    </div>
                </div>
            </div>
        </section>
    );
}
