import { Suspense } from "react";
import { API_ENDPOINTS } from "@/lib/apiEndpoints";
import InnerBanner from "@/components/InnerBanner";
import Link from "next/link";
import "./blog.css";
import { Metadata } from "next";
import { blogListMeta } from "@/lib/seo/blogListMeta";

export const dynamic = "force-dynamic";

export const metadata = blogListMeta;

/* Loader (ONLY new thing) */
function PageLoader() {
    return (
        <div className="min-vh-100 d-flex align-items-center justify-content-center">
            <div className="spinner-border text-primary" />
        </div>
    );
}

/* Async data layer (NO UI change) */
async function BlogData() {
    // We can also use page data for the banner if we want, but keeping it simple for now as per original code
    // actually original just hardcoded InnerBanner title="Blogs".

    // Fetch blogs list
    const blogs_res = await API_ENDPOINTS.BLOGS.LIST();
    if (!blogs_res.ok) throw new Error("Failed to fetch blogs");

    const blogs = await blogs_res.json();

    return (
        <>
            <InnerBanner title="Blogs" breadcrumb="Blogs" />

            <div className="blog-inner py-5">
                <div className="container">
                    <div className="row g-4">
                        {blogs.map((post: any) => (
                            <div key={post.id} className="col-lg-4 col-md-6">
                                <div className="blog-card">
                                    <Link
                                        href={`/blog/${post.slug}`}
                                        style={{
                                            textDecoration: "none",
                                            color: "inherit",
                                        }}
                                    >
                                        <div className="blog-img-wrapper">
                                            <span className="category-badge">
                                                {post.category}
                                            </span>

                                            <img
                                                src={post.image}
                                                alt={post.title}
                                                className="blog-img"
                                                width="400"
                                                height="250"
                                                loading="lazy"
                                            />
                                        </div>

                                        <div className="blog-content">
                                            <p className="text-muted mb-2">
                                                <i className="fa-regular fa-calendar me-2"></i>
                                                {post.date}
                                            </p>

                                            <h2 className="blog-title">
                                                {post.title}
                                            </h2>

                                            <p className="blog-excerpt">
                                                {post.excerpt}
                                            </p>

                                            <span className="read-more">
                                                Read More{" "}
                                                <i className="fa-solid fa-arrow-right mx-1"></i>
                                            </span>
                                        </div>
                                    </Link>
                                </div>
                            </div>
                        ))}
                    </div>
                </div>
            </div>
        </>
    );
}

export default function BlogPage() {
    return (
        <>
            <Suspense fallback={<PageLoader />}>
                <BlogData />
            </Suspense>
        </>
    );
}
