"use client";

import React, { useState } from 'react';
import InnerBanner from "../../components/InnerBanner";

function stripHtml(html: string): string {
    const div = document.createElement("div");
    div.innerHTML = html;
    return div.textContent || div.innerText || "";
}

interface FaqClientProps {
    pageData: any;
    faqs: any[];
}

export default function FaqClient({ pageData, faqs }: FaqClientProps) {
    const [openIndex, setOpenIndex] = useState<number | null>(null);

    const headline = pageData?.page_headline || "FAQ";
    const breadcrumbHeadline = pageData?.breadcrumb_headline || "FAQ";

    const toggleFAQ = (index: number) => {
        setOpenIndex(openIndex === index ? null : index);
    };

    return (
        <>
            <InnerBanner title={headline} breadcrumb={breadcrumbHeadline} />

            <div className="container my-5">
                <h2 className="text-center mb-4">Frequently Asked Questions</h2>

                <div className="accordion w-75 m-auto" id="faqAccordion">
                    {faqs.map((faq, index) => (
                        <div
                            className="accordion-item border-0 mb-2"
                            key={index}
                            style={{ backgroundColor: "#5596ff" }} // Bootstrap primary blue
                        >
                            <h2 className="accordion-header">
                                <button
                                    className={`accordion-button d-flex justify-content-between align-items-center text-white ${openIndex === index ? "" : "collapsed"
                                        }`}
                                    type="button"
                                    onClick={() => toggleFAQ(index)}
                                    style={{
                                        backgroundColor: "#5596ff",
                                        boxShadow: "none",
                                    }}
                                >
                                    <span>{faq.question}</span>

                                    <i
                                        className={`fa-solid ${openIndex === index ? "fa-minus" : "fa-plus"
                                            }`}
                                    />
                                </button>
                            </h2>

                            <div
                                className={`accordion-collapse collapse ${openIndex === index ? "show" : ""
                                    }`}
                            >
                                <div className="accordion-body text-black bg-light">
                                    {stripHtml(faq.answer)}
                                </div>
                            </div>
                        </div>
                    ))}
                </div>

                <style jsx>{`
                    .accordion-button::after {
                    display: none;
                    }
                `}</style>
            </div>
        </>
    );
}
