"use client";

import React from "react";
import "./CustomReportSection.css";

interface CompanyContact {
    availability?: string;
    whatsapp_phone?: string;
}

interface CustomReportData {
    headline: string;
    description: string;
    company: CompanyContact | null;
}

interface CustomReportSectionProps {
    data: CustomReportData | null;
}

export default function CustomReportSection({ data }: CustomReportSectionProps) {
    if (!data || !data.headline || !data.company) {
        return null;
    }

    const { headline, description, company } = data;

    return (
        <section className="crs-wrapper">
            {/* Top text block */}
            <div className="container text-center py-5">
                <h3 className="crs-heading">{headline}</h3>

                <div
                    className="crs-subtext"
                    dangerouslySetInnerHTML={{ __html: description }}
                />
            </div>

            {/* Bottom bar */}
            <div className="crs-bottom-bar">
                <div className="container">
                    <div className="row align-items-center g-3">
                        {/* Left text */}
                        <div className="col-12 col-lg-6">
                            <h6
                                className="crs-support-text mb-0"
                                dangerouslySetInnerHTML={{
                                    __html: company.availability || "",
                                }}
                            />
                        </div>

                        {/* Right buttons */}
                        <div className="col-12 col-lg-6">
                            <div className="d-flex flex-wrap justify-content-lg-end gap-3">
                                <button className="crs-btn crs-btn-outline d-flex align-items-center gap-2">
                                    <span className="crs-btn-icon">
                                        <i className="fa-solid fa-phone"></i>
                                    </span>
                                    <span>{company.whatsapp_phone || ""}</span>
                                </button>

                                <button className="crs-btn crs-btn-primary d-flex align-items-center gap-2">
                                    <span className="crs-btn-icon crs-btn-icon-light">
                                        <i className="fa-brands fa-whatsapp"></i>
                                    </span>
                                    <span>Send Message</span>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    );
}
