"use client";

import { motion } from "framer-motion";
import Link from "next/link";

export default function InnerBanner({ title, breadcrumb }: any) {
    return (
        <section className="inner-banner text-white py-5 position-relative">
            <motion.div
                className="container text-left"
                initial={{ opacity: 0, y: 40 }}
                whileInView={{ opacity: 1, y: 0 }}
                transition={{ duration: 0.6 }}
            >
                <div className="inner-title">
                    <h2 className="fw-bold text-black">{title}</h2>

                    <ul className="list-inline d-flex gap-2 mt-2  text-black">
                        <li className="list-inline-item  text-black">
                            <Link href="/" className="text-decoration-none  text-black">
                                Home
                            </Link>
                        </li>
                        <li className="list-inline-item " >
                            <i className="fa-solid fa-angles-right"></i>
                        </li>
                        <li className="list-inline-item text-black-50">{breadcrumb}</li>
                    </ul>
                </div>
            </motion.div>
        </section>
    );
}
