'use client';

import React, { useEffect } from "react";
import { useRouter, useSearchParams } from "next/navigation";
import { getToken } from "@/lib/apiEndpoints";
import Link from "next/link";

export default function OrderPendingClient() {
    const router = useRouter();
    const searchParams = useSearchParams();
    const orderNumber = searchParams.get("order");
    const isLoggedIn = !!getToken();

    useEffect(() => {
        if (!isLoggedIn) {
            router.replace("/login");
        }
    }, [isLoggedIn, router]);

    return (
        <div className="order-status-card pending">
            <i className="fa-solid fa-clock fa-4x text-warning mb-3"></i>

            <h2 className="mb-2">Order Pending</h2>
            <p className="text-muted">
                Your order has been received and is currently being processed.
            </p>

            {orderNumber && (
                <p className="fw-semibold mt-3">
                    Order Number: <span className="text-primary">{orderNumber}</span>
                </p>
            )}

            <div className="mt-4 d-flex justify-content-center gap-3">
                <Link href="/dashboard" className="btn btn-warning text-white">
                    Track Order
                </Link>
                <Link href="/" className="btn btn-outline-secondary">
                    Back to Home
                </Link>
            </div>
        </div>
    );
}
