// src/data/blogs.tsx
export interface BlogPost {
  id: string | number;
  slug: string;
  title: string;
  excerpt: string;
  short: string;
  content: string;
  image: string;
  coverImage: string;
  category: string;
  author: string;
  date: string;
  readTime: string;
}

export const blogs: BlogPost[] = [
  {
    id: '1',
    slug: 'future-of-web-development',
    title: 'The Future of Web Development',
    excerpt: 'Exploring the latest trends and technologies shaping the future of web development.',
    short: 'Exploring the latest trends and technologies shaping the future of web development.',
    content: `Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.`,

    image: '/img/blog_image-1.png',
    coverImage: '/img/blog_image-1.png',
    category: 'Development',
    author: 'Admin',
    date: '2023-11-20',
    readTime: '5 min read'
  },
  {
    id: '2',
    slug: 'ui-ux-design-principles',
    title: 'UI/UX Design Principles',
    excerpt: 'Essential UI/UX design principles every developer should know in 2023.',
    short: 'Essential UI/UX design principles every developer should know in 2023.',
    content: `Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.`,

    image: '/img/blog_image-2.png',
    coverImage: '/img/blog_image-2.png',
    category: 'Design',
    author: 'Admin',
    date: '2023-11-22',
    readTime: '4 min read'
  },
  {
    id: '3',
    slug: 'mobile-first-approach',
    title: 'Mobile First Approach',
    excerpt: 'Why mobile-first design is more important than ever in today\'s digital landscape.',
    short: 'Why mobile-first design is more important than ever in today\'s digital landscape.',
    content: `Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.`,
    image: '/img/blog_image-1.png',
    coverImage: '/img/blog_image-1.png',
    category: 'Design',
    author: 'Admin',
    date: '2023-11-24',
    readTime: '3 min read'
  },

  {
    id: '4',
    slug: 'performance-optimization',
    title: 'Performance Optimization',
    excerpt: 'Advanced techniques to optimize your website\'s performance and loading times.',
    short: 'Advanced techniques to optimize your website\'s performance and loading times.',
    content: `Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.`,
    image: '/img/blog_image-3.png',
    coverImage: '/img/blog_image-3.png',
    category: 'Development',
    author: 'Admin',
    date: '2023-11-26',
    readTime: '6 min read'
  },
];

// Function to add new blog
export function addBlog(blog: Omit<BlogPost, "id">) {
  const newBlog: BlogPost = {
    id: blogs.length + 1,
    ...blog,
  };
  blogs.push(newBlog);
  return newBlog;
}
