import { Metadata } from "next";

function stripHtml(html: string): string {
    if (!html) return "";
    return html.replace(/<[^>]*>?/gm, "").trim();
}

/**
 * Metadata for generic pages fetched via API_ENDPOINTS.PAGE(id)
 */
export function buildPageMeta(data: any, path: string, defaultTitle: string = "Excelsius"): Metadata {
    const title = data.meta_title || data.page_headline || defaultTitle;
    const description = stripHtml(data.meta_description || data.page_description || "");
    const keywords = data.meta_keywords || "";

    const imageUrl = data.meta_image || "/og-default.jpg"; // You might want to define a global default

    return {
        title,
        description,
        keywords,

        alternates: {
            canonical: path,
        },

        openGraph: {
            title,
            description,
            url: path,
            type: "website",
            images: [
                {
                    url: imageUrl,
                    width: 1200,
                    height: 630,
                    alt: title,
                },
            ],
        },

        twitter: {
            card: "summary_large_image",
            title,
            description,
            images: [imageUrl],
        },
    };
}
